using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Sending_SMS_through_MS_SQL_Server
{
    public partial class MainForm : Form
    {
        private void MainForm_Load(object sender, EventArgs e)
        {
            updateOutgoingMessages();
            updateIncomingMessages();
        }

        public MainForm()
        {
            InitializeComponent();

            listViewOut.View = View.Details;
            listViewOut.ShowItemToolTips = true;
            listViewOut.Columns.Add("ID", 50);
            listViewOut.Columns.Add("Sender", 100);
            listViewOut.Columns.Add("Receiver", 100);
            listViewOut.Columns.Add("Sent time", 100);
            listViewOut.Columns.Add("Received time", 100);
            listViewOut.Columns.Add("Operator", 50);
            listViewOut.Columns.Add("Status", 50);
            listViewOut.Columns.Add("Message type", 50);
            listViewOut.Columns.Add("Message text", 100);

            listViewIn.View = View.Details;
            listViewIn.ShowItemToolTips = true;
            listViewIn.Columns.Add("ID", 50);
            listViewIn.Columns.Add("Sender", 100);
            listViewIn.Columns.Add("Receiver", 100);
            listViewIn.Columns.Add("Sent time", 100);
            listViewIn.Columns.Add("Received time", 100);
            listViewIn.Columns.Add("Operator", 50);
            listViewIn.Columns.Add("Message type", 50);
            listViewIn.Columns.Add("Message text", 100);
        }

        private void buttonComposeMessage_Click(object sender, EventArgs e)
        {
            ComposeMessageForm cmf = new ComposeMessageForm();
            cmf.ShowDialog(this);
            updateOutgoingMessages();
            updateIncomingMessages();
        }

        private void updateOutgoingMessages()
        {
            DatabaseHandling.updateListViewOut(listViewOut);
        }

        private void updateIncomingMessages()
        {
            DatabaseHandling.updateListViewIn(listViewIn);
        }

        private void buttonRefreshOut_Click(object sender, EventArgs e)
        {
            updateOutgoingMessages();
        }

        private void buttonRefreshIn_Click(object sender, EventArgs e)
        {
            updateIncomingMessages();
        }
    }
}